static int stat;
#include <cvirte.h>		/* Needed if linking in external compiler; harmless otherwise */
#include <userint.h>
#include "sample.h"
#include <windows.h>
#include <ansi_c.h>
#include "d:\drvlinx\dlapi\drvlinx.h"
#include "d:\drvlinx\dlapi\dlcodes.h"
static int panelHandle;


HWND window;

HINSTANCE driverInstance;

DL_SERVICEREQUEST *pSR;       

	
int main (int argc, char *argv[])
{
	
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "sample.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	return 0;
}

int CVICALLBACK update (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		static double value;
		case EVENT_COMMIT:
			
			break;
	}
	return 0;
}

int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
			free(pSR);
			pSR = NULL;
			CloseDriverLINX(driverInstance);
			QuitUserInterface (0);
			break;
	}
	return 0;
}

int CVICALLBACK Initialize (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
			window=FindWindow(NULL,"KPCI_PIO24 Example");		//Get the Window handle from the CVI panel
			driverInstance=OpenDriverLINX(window,"");  //Pass the window handle to open the driver
			pSR=(DL_SERVICEREQUEST*)malloc(sizeof(DL_SERVICEREQUEST));  //Allocate space for the Service Request
			memset(pSR,0,sizeof(DL_SERVICEREQUEST));   //Initialize the Service Request
			DL_SetServiceRequestSize(*pSR);    	//Setup the Service Request for usage
			pSR->hWnd=window;                	//Set the Widows handle property
			pSR->device=0; 						//Set the device property, in this case it is device 0	
			pSR->subsystem=DEVICE;				//We are commnicating with the DEVICE, not AI, AO, etc..																		
			pSR->mode=OTHER;					//The mode is OTHER, not DMA or INTerrupt
			pSR->operation=INITIALIZE;			//The operation is to INITIALIZE the driver													 
			DriverLINX(pSR);					//Execute the Service Request
			
			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			break;
	}
	return 0;
}

int CVICALLBACK conf_do (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			pSR->subsystem = DO;				//Talk to the Digital Output subsystem
			pSR->mode = OTHER;					//The mode is OTHER, not DMA ot INTerrupt
			pSR->operation = CONFIGURE;			//The operation is to CONFIGURE
	
			pSR->timing.typeEvent = DIOSETUP;	//This is a Digital I/O setup event
			pSR->timing.u.diSetup.channel = 0;	//We are setting channel 0
			pSR->timing.u.diSetup.mode = DIO_BASIC;	//The mode is Digital I/O basic operation

			DriverLINX(pSR);					//Execute the Service Request

			pSR->timing.typeEvent = NULLEVENT;	//Put the event back to NULL so we can reuse pSR

			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}

		break;
		}
	return 0;
}

int CVICALLBACK digout (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
			pSR->mode=POLLED;					//The mode is POLLED I/O
			pSR->channels.nChannels=1;			//The total number of channels is 1
			pSR->channels.chanGain[0].channel=0;//We are talking to channel 0
			pSR->status.typeStatus=IOVALUE;		//We are sending an I/O value
			pSR->status.u.ioValue=255;			//We are sending a value of 255,i.e. all 8 lines are high
			pSR->operation = START;				//The operationi is to START
			
			DriverLINX(pSR);					//Execute the Service Request
			
			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			break;
	}
	return 0;
}
